---
Difficulty: Medium
Source: Daily-Question(POTD 20-Nov)
Tags:
    - Hash Table
    - String
    - Sliding Window
---

# 🚀 *2516 - Take K of Each Character From Left and Right* 🧠

### Problem Link:
[**LeetCode - Take K of Each Character**](https://leetcode.com/problems/take-k-of-each-character-from-left-and-right/description/?envType=daily-question&envId=2024-11-20)


## 💡 **Problem Breakdown:**

You are given a string `s` containing only characters **'a'**, **'b'**, and **'c'**, and a non-negative integer `k`. Each minute, you may take either the **leftmost** or the **rightmost** character of `s`.

### Your task:
Find the **minimum number of minutes** required to take **at least k of each character** from `s`. If this isn’t possible, return `-1`.


## 🔍 **Example Walkthrough:**

### Example 1:  
**Input:**  
`s = "aabaaaacaabc"`, `k = 2`  
**Output:**  
`8`

**Explanation:**  
- **Step 1:** Take 3 characters from the left: 2 'a's, 1 'b'.
- **Step 2:** Take 5 characters from the right: 4 'a's, 2 'b's, and 2 'c's.
- Total time = `3 + 5 = 8 minutes`.


### Example 2:  
**Input:**  
`s = "a"`, `k = 1`  
**Output:**  
`-1`

**Explanation:**  
You can't take **1 'b'** or **1 'c'** from the string, so it's impossible. Hence, return `-1`.


## 🎯 **My Approach:**

1. **Counting the Characters:**
   - First, count how many **'a'**, **'b'**, and **'c'** exist in the string.
   
2. **Two Pointer Technique:**
   - Use two pointers: one starting from the **left** and the other from the **right**.
   - Gradually take characters from both ends, tracking how many **'a'**, **'b'**, and **'c'** are collected.

3. **Validating the Result:**
   - If it's possible to gather **k of each character**, return the total time taken.
   - Otherwise, return `-1` if the task can't be completed.


## 🕒 **Time Complexity:**

- **Time Complexity:** O(n) — We traverse the string once, making it linear in time complexity.
- **Space Complexity:** O(1) — Only a constant amount of space is used to store counts.


## 📝 **Solution Code**

## Code (C):

```c
#include <string.h>

int takeCharacters(char* s, int k) {
    int cnt[3] = {0};
    int n = strlen(s);
    
    for (int i = 0; i < n; ++i) {
        cnt[s[i] - 'a']++;
    }

    if (cnt[0] < k || cnt[1] < k || cnt[2] < k) return -1;

    int maxWindow = 0, j = 0;
    for (int i = 0; i < n; ++i) {
        cnt[s[i] - 'a']--;

        while (cnt[0] < k || cnt[1] < k || cnt[2] < k) {
            cnt[s[j] - 'a']++;
            j++;
        }

        maxWindow = (i - j + 1) > maxWindow ? (i - j + 1) : maxWindow;
    }

    return n - maxWindow;
}
```

## Code (C++):

```cpp
class Solution {
public:
    int takeCharacters(string s, int k) {
        int cnt[3] = {}; 
        int n = s.size();

        for (char c : s) ++cnt[c - 'a'];
        if (cnt[0] < k || cnt[1] < k || cnt[2] < k) return -1;

        cnt[0] -= k; cnt[1] -= k; cnt[2] -= k;
        int maxWindow = 0, j = 0;
        for (int i = 0; i < n; ++i) {
            --cnt[s[i] - 'a']; 
            while (cnt[s[i] - 'a'] < 0) {
                ++cnt[s[j++] - 'a'];
            }
            maxWindow = max(maxWindow, i - j + 1);
        }

        return n - maxWindow;
    }
};
```

## Code (Java):

```java
class Solution {
    public int takeCharacters(String s, int k) {
        int n = s.length();
        int[] cnt = new int[3];  

        for (char c : s.toCharArray()) {
            cnt[c - 'a']++;
        }

        if (cnt[0] < k || cnt[1] < k || cnt[2] < k) return -1;

        int maxWindow = 0, j = 0;
        for (int i = 0; i < n; ++i) {
            cnt[s.charAt(i) - 'a']--;  
            while (cnt[0] < k || cnt[1] < k || cnt[2] < k) {
                cnt[s.charAt(j) - 'a']++;  
                j++;  
            }

            maxWindow = Math.max(maxWindow, i - j + 1);
        }

        return n - maxWindow;  
    }
}
```

## Code (Python3):

```python
class Solution:
    def takeCharacters(self, s: str, k: int) -> int:
        cnt = [0] * 3
        for c in s:
            cnt[ord(c) - ord('a')] += 1

        if cnt[0] < k or cnt[1] < k or cnt[2] < k:
            return -1

        mx = j = 0
        for i, c in enumerate(s):
            cnt[ord(c) - ord('a')] -= 1
            while cnt[0] < k or cnt[1] < k or cnt[2] < k:
                cnt[ord(s[j]) - ord('a')] += 1
                j += 1
            mx = max(mx, i - j + 1)
        
        return len(s) - mx 
```

## Code (Rust):

```rust
use std::collections::HashMap;

impl Solution {
    pub fn take_characters(s: String, k: i32) -> i32 {
        let n = s.len();
        let mut cnt: HashMap<char, i32> = HashMap::new();

        for c in s.chars() {
            *cnt.entry(c).or_insert(0) += 1;
        }

        if "abc".chars().any(|c| cnt.get(&c).unwrap_or(&0) < &k) {
            return -1;
        }

        let mut mx = 0;
        let mut j = 0;
        let s = s.as_bytes(); 

        for i in 0..n {
            let c = s[i] as char; 
            *cnt.get_mut(&c).unwrap() -= 1;

            while cnt.get(&c).unwrap() < &k {
                let c_left = s[j] as char;
                *cnt.get_mut(&c_left).unwrap() += 1;
                j += 1;
            }

            mx = mx.max(i - j + 1);
        }

        (n as i32) - (mx as i32)
    }
}
```



## 🎯 **Contribute or Ask Questions:**
For more discussions, questions, or help with the solution, feel free to reach out on LinkedIn: [**Connect with Me!**](https://www.linkedin.com/in/het-patel-8b110525a/).


## <img src="https://github.com/user-attachments/assets/35f6838c-52f5-4e48-8a98-c5203f8c57e3" style="width:25px; color: #FFD700" alt="Star GIF"> **Enjoying the Solution?**  
If this helped you, please **star this repo** to support the efforts and keep it growing!

